Program Kursovik_1;
uses crt, graph;

{=========== Declares variables =========================================}
const
BGI = 'a:\bgi';
k=1.1;
tau=0.7;
dzeta=0;
var     omega, x, step, y: real;
	MaxX, MinX, MaxY, MinY: Extended;
	WMaxX, WMinX, WMaxY, WMinY: Integer;
	cc : Byte;
	key : Char;
	i : LongInt;
	HighQuality : Boolean;

{=========== function ====================}
function f (x : Extended): Extended;
begin
f:= sqrt(k/(sqr(1-sqr(tau)*sqr(x)

) + (sqr(2-dzeta*x))));
end;

{=========== math x to graph x =========}
function GrX (x : Extended) : Integer;
begin
GrX := round((x - MinX) * (WMaxX - WMinX) / (MaxX - MinX) + WMinX);
end;
{=========== math y to graph y =========}
function GrY (y : Extended) : Integer;
var gy : LongInt;
begin
gy := round((WMaxY - WMinY) - (y - MinY) * (WMaxY - WMinY) / (MaxY - MinY) + WMinY);
if (gy <= WMaxY) AND (gy >= WMinY) then GrY := gy;
end;

{=========== wants user to exit or not? ==}
procedure ExitOrNot;
begin
if keypressed then
	begin
	key := readkey;
	if (key = 'q') then halt;
	end;
end;

{=========== Inits graphic mode, sets window =============================}
procedure Graphinit;
var	grDriver, grMode :Integer;
begin
randomize;
grDriver := Detect;
InitGraph (grDriver, grMode, BGI);
WMaxX := GetMaxX; WMinX := 0; WMaxY := GetMaxY; WMinY := 50;
end;

{================= Coordinate system ====================================}
procedure Draw;
var r: Integer;
    text: String[5];
begin
setcolor (Lightgreen);
rectangle (GrX (MinX), GrY (MinY), GrX (MaxX), GrY (MaxY));

line (GrX (0), GrY (MinY), GrX (0), GrY (MaxY));
line (GrX (MinX), GrY (0), GrX (MaxX), GrY (0));

line (GrX (MaxX), GrY (0), GrX (MaxX) - 15, GrY (0) - 5);
line (GrX (MaxX), GrY (0), GrX (MaxX) - 15, GrY (0) + 5);

line (GrX (0), GrY (MaxY), GrX(0) - 5, GrY (MaxY) + 15);
line (GrX (0), GrY (MaxY), GrX(0) + 5, GrY (MaxY) + 15);

outtextxy (GrX (MaxX) - 15, (GrY (0) - 15), 'w');
outtextxy (GrX (0) - 15, (GrY (MaxY) + 7), 'A');
outtextxy (GrX (0) + 7, (GrY (0) - 10), 'o');

for r := round(MinX) to round(MaxX) do line (GrX (r), GrY (0) + 3, GrX (r), GrY (0) - 3);
for r := round(MinY) to round(MaxY) do line (GrX (0) + 3, GrY (r), GrX (0) - 3, GrY (r));
for r := round(MinX) to round(MaxX) do
    begin
    str(r, text);
    if (r <> 0) then outtextxy (GrX (r), GrY (0) + 10, text);
    end;
for r := round(MinY) to round(MaxY) do
    begin
    str(r, text);
    if (r <> 0) then outtextxy (GrX (0) + 10, GrY (r), text);
    end;
end;

{=========== Asks user to enter values, if bad - autodetect =============}
procedure Dialog;
begin
clrscr;
       {=== OMEGA Value. Detect correct limit ===}
writeln ('Enter OMEGA value:');
read(omega);
if (omega > 10) or (omega < 0) then halt;
       {========== End OMEGA operation ==========}

       writeln (f(x):5:2);
       readln;
writeln ('Enter MinX and MaxX');
readln (MinX, MaxX);
if (MaxX <= MinX) then
	begin
	writeln ('MaxX <= MinX !!!  Default parametrs');
	MaxX := 8;
	MinX := -8;
        writeln ('MinX = ', MinX:2:2, ' MaxX = ', MaxX:2:2);
	writeln;
	while not keypressed do;
	end;

writeln ('Enter MinY and MaxY:');
readln (MinY, MaxY);

if (MaxY <= MinY) then
	begin
        writeln(' ');
	writeln ('Error!');
        writeln ('MaxY <= MinY ');
        readln;
        halt;
        end;
HighQuality := True;
step := 2;
end;

{============================ Main program ==============================}
begin
Dialog;
Graphinit;
Draw;

while (key <> 'q') do
	begin
	repeat cc := random (14) + 1; until cc <> getcolor;
	x := MinX;
	i := trunc (MinX / step);
	setcolor (WHITE);
	outtextxy (5, 5, 'Press any key for REFRESH...');
        setcolor (cc);
	while x <= MaxX do
		begin
		y := f(x);
		circle (GrX(x), GrY(y), 1);
			begin
			x := i * step;
			inc (i);
			end;
		exitornot;
		end;
	outtextxy (15, 25, 'Refreshing grafic');
	while not keypressed do;
	step := step / 2;
	end;
CloseGraph;
end.